
#include <stdio.h>
#include <errno.h>

#include <nl_types.h>
#include <iconv.h>
#include <string.h>
#include <locale.h>
#include <langinfo.h>


#define ICONV_DONE() (r>=0)
#define ICONV_INVAL() (r <0 && (errno==EILSEQ))
#define ICONV_OVER() (r <0 && (errno==E2BIG))
#define ICONV_TRUNC() (r <0 && (errno==EINVAL))


#define USAGE 1
#define ERROR 2
#define INCOMP 3


/* ibuf is the buffer to hold characters to be converted.
   obuf is the buffer to hold the converted characters. */
char ibuf[BUFSIZ], obuf[BUFSIZ];


extern int errno;

main (argc,argv)
int argc;
char **argv;
{

 size_t  ileft; /* the number of bytes in ibuf left to be converted. */ 
 size_t  oleft; /* size in bytes of the available space in obuf. */
 nl_catd catd;  /* message catalog descriptor. */
 iconv_t cd;    /* conversion descriptor. */
 int r;         /* return code. */
 char *ip,*op;  /* working pointer to point to positions in ibuf and obuf.*/
 char *current_codeset; /* codeset of the current locale */

 setlocale(LC_ALL,"");
 catd = catopen (argv[0],0); /* open the message catalog. */

 /* Read in the first line of stdin, which is a tag to indicate what
    codeset the data following is encoded in. This would be the 
    codeset to convert from. */
 fgets(ibuf, BUFSIZ, stdin);

 /* Since the string read by fgets() always includes the newline char,
    replace it with null. */
 ibuf[strlen(ibuf)-1] = (char) NULL;

 /* Use nl_langinfo() to find out the current-locale's codeset which is        
    the codeset to convert to. */
 current_codeset =nl_langinfo(CODESET);

 /* If the file is encoded in the current-locale's codeset, there is no
    need to convert. */
 if (strcmp(ibuf, current_codeset) == 0) {
     printf("Same code set, no need to convert.\n");
     exit(-1);
    }

 cd = iconv_open(current_codeset, ibuf);
 if ((int)cd == -1) 
	printf("Error opening the converter from %s to %s\n", ibuf,
		current_codeset );
 ileft=0;


 while(!feof(stdin)) {
 /*
 * After the next operation,ibuf will
 * contain new data plus any truncated
 * data left from the previous read.
 */
 ileft+=fread(ibuf+ileft,1,BUFSIZ-ileft,stdin); /* "ileft" bytes were
                                                   left in ibuf by the
                                                   previous iconv() */
 do {
  ip=ibuf;  /* initialize ip to the beginning of ibuf. */
  op=obuf;  /* initialize op to the beginning of obuf. */
  oleft=BUFSIZ; /* The whole obuf is available at this point. */


  r=iconv(cd,&ip,&ileft,&op,&oleft); /* After this operation, ileft
                                        and oleft are updated by iconv() */


  if(ICONV_INVAL()){
   fprintf(stderr,
      catgets(catd,NL_SETD,ERROR,"invalid input\n"));
   exit(2);
   }


  fwrite(obuf,1,BUFSIZ-oleft,stdout); /* write the converted characters to
                                        stdout. */

  if(ICONV_TRUNC() || ICONV_OVER())
  /*
  *Data remaining in buffer-copy
  *it to the beginning
  */
       memcpy(ibuf,ip,ileft);

  /*
  *loop until all characters in the input
  *buffer have been converted.
  */
 } while(ICONV_OVER());

} /* while(!feof(stdin)) */


 if(ileft!=0){
  /*
  *This can only happen if the last call
  *to iconv() returned ICONV_TRUNC, meaning
  *the last data in the input stream was
  *incomplete.
  */
 fprintf(stderr,catgets(catd,NL_SETD,INCOMP,"input incomplete\n"));
 exit(3);
 }


 iconv_close(cd);
 exit(0);
}

